<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

// $router->get('/', function () use ($router) {
//     return $router->app->version();
// });
$router->get('/test', function () {
    return response()->json(['message' => 'API is working']);
});

$router->group(['prefix' => 'api'], function () use ($router) {

    $router->post('load', 'LoaderController@index');
    $router->post('menus', 'MenusController@index');
    $router->get('menu/{id}/image', 'MenusController@getImage');

    $router->post('order', 'SalesController@order');
    $router->post('order/multiple', 'SalesController@orderMultiple');
    $router->post('reserve', 'SalesController@reserve');

    $router->post('customer/logs', 'CustomersController@logsRecording');
    $router->post('customer/cartsCreatedlogs', 'CustomersController@updateCartsCreatedlogs');
    $router->post('customer/checkoutlogs', 'CustomersController@updateCheckoutlogs');
    $router->post('customer/orders', 'CustomersController@orders');
    $router->post('customer/loyaltycheck', 'CustomersController@loyaltyCardCheck');
    $router->post('customer/reservations', 'CustomersController@reservations');
    $router->post('customer/order/view', 'CustomersController@orderView');
    $router->post('customer/add', 'CustomersController@add');
    $router->post('customer/notifications', 'CustomersController@notifications');
    $router->post('customer/notifications/seen', 'CustomersController@notificationsSeen');
    $router->post('customer/do/favorite', 'CustomersController@addRemoveFavorite');
    $router->post('email/verify', 'CustomersController@EmailVerify');
    $router->post('email/tester', 'CustomersController@Mailer_testing');
    $router->post('email/request_send', 'CustomersController@EmaiSendRequest');
    $router->post('email/contact_us', 'CustomersController@contactus_email');
    $router->post('email/send_email', 'CustomersController@mail');

    $router->post('stores', 'StoresController@index');
    $router->get('store/{id}/image', 'StoresController@getImage');
    $router->get('store/brand/{id}/image', 'StoresController@getBrandImage');
    $router->post('store/menu', 'StoresController@getMenus');

    $router->post('ipay88/payment', 'SalesController@processIpay88');
    $router->post('store/schedule', 'StoresController@schedules');
    $router->post('store/location_delivery_charge', 'StoresController@location_delivery_charge');
    $router->post('store/promos', 'StoresController@promos');
    $router->post('store/app_config', 'StoresController@appConfig');
    $router->post('store/code', 'StoresController@promoCode');
    $router->post('user/guest/check', 'UsersController@userGuest');
    $router->post('user/user/check', 'UsersController@userRegister');
    $router->post('user/changepasscheck', 'UsersController@changePassCheck');
    $router->post('user/changepass', 'UsersController@changePass');
    $router->get('store/promo/{id}/image', 'StoresController@getPromoImage');
    $router->post('user/login', 'UsersController@login');
    $router->post('map/search', 'LoaderController@googleMapSearch');
});

$router->group(['prefix' => 'api', 'middleware' => ['auth:api']], function () use ($router) {
    $router->post('store/orders', 'StoresController@orders');
    $router->post('user/address/check', 'UsersController@addressCheck');
    $router->post('store/order/last', 'StoresController@orderLast');
    $router->post('store/order/update', 'StoresController@orderUpdate');
    $router->post('store/order/update/items', 'StoresController@orderUpdateItems');
    $router->post('customer/details', 'CustomersController@details');
    $router->post('customer/updateAccount', 'CustomersController@updateAccount');
    $router->post('customer/address/updateAddress', 'CustomersController@updateAddress');
    $router->post('customer/address/add', 'CustomersController@addressAdd');
    $router->post('customer/address/default', 'CustomersController@addressDefault');
    $router->post('customer/address/delete', 'CustomersController@addressDelete');

    $router->post('customer/{id}/profile/edit', 'CustomersController@updateProfilePic');
    $router->get('customer/{id}/profile/edit', 'CustomersController@updateProfilePic');
});
