<?php
namespace App\Services;
use Carbon\Carbon;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;

use App\Models\Stores\StoresModel;
use App\Models\Stores\StoreMenusModel;
use App\Models\Stores\BrandsModel;
use App\Models\Users\CustomersModel;
use App\Models\Sales\SalesModel;
use App\Models\Sales\SalesDetailsModel;
use App\Models\Sales\SalesItemsModel;
use App\Models\Sales\SalesItemsTaxesModel;
use App\Models\Sales\SalesChargesModel;
use App\Models\Sales\SalesPaymentsModel;
use App\Models\Sales\SalesDeliveriesModel;
use App\Models\Sales\SalesRidersModel;
use App\Models\Files\FilesModel;
use App\Models\Stores\OrderTypeModel;
use App\Models\Stores\LocationDeliveryChargeModel;
use App\Models\Stores\PromosModel;
use App\Models\Stores\AppConfigModel;
use App\Models\Stores\PromoCodesModel;

class StoresService {
	/*
	 *  
	 * saves the order
	 */
	public function get($store_id=null,$active_only=true){
		$stores = null;
		$stores = StoresModel::where(function($query) use ($store_id){
					  	if($store_id != null) $query->where('id',$store_id);
					  })
					  ->where(function($query) use ($active_only){
					  	if($active_only){
					  		$query->where('deleted',0);
					  	}
					  });
		// echo (str_replace_array('?',$deliveries->getBindings(),$deliveries->toSql()));
		if($store_id != null && !is_array($store_id)) return $store_id->first();
		else return $stores->get();
	}
	/*
	 *  
	 * saves the order
	 */
	public function getAll($store_id=null,$active_only=true){
		$stores = null;
		$stores = StoresModel::with(['store_menus.menu_details','brand_details','hub_details'])
					  ->where(function($query) use ($store_id){
					  	if($store_id != null) $query->where('id',$store_id);
					  })
					  ->where(function($query) use ($active_only){
					  	if($active_only){
					  		$query->where('deleted',0)->where('closed',0);
					  	}
					  });
		// echo (str_replace_array('?',$deliveries->getBindings(),$deliveries->toSql()));
		if($store_id != null && !is_array($store_id)) return $store_id->first();
		else return $stores->get();
	}
	/*
	 *  
	 * saves the order
	 */
	public function getMenus($store_id,$brand_id=null,$active_only=true, $item_id_filter=null){
		$stores = null;
		$with = ['menu_details.menu_modifiers.modifier_group.modifier_details.modifier','menu_details.category_details.brand_list'];
		if($brand_id)
			$with[] = 'store_details.brand_details';

		$stores = StoreMenusModel::with($with)
					  ->where(function($query) use ($store_id){
					  	if($store_id) $query->where('location_id',$store_id);

					  })
					  ->whereHas('menu_details',function($query) use ($active_only,$item_id_filter){
					  	// echo "<pre>",print_r($item_id_filter),"</pre>";die();
					  	if($item_id_filter){
							$query->where('item_id',$item_id_filter);
					  	}
					  	if($active_only){
					  		$query->where('deleted',0);
					  	}
					  })
					  ->whereHas('store_details',function($query) use ($active_only){
					  	if($active_only){
					  		$query->where('deleted',0);
					  	}
					  })
					  ->whereHas('store_details.brand_details',function($query) use ($brand_id){
					  	if($brand_id){
					  		$query->where('brand_id',$brand_id);
					  	}
					  });
		// echo (str_replace_array('?',$stores->getBindings(),$stores->toSql()));
		return $stores->get();
	}
	/*
	 *  
	 * GET the orderS
	 */
	public function orders($customer_id=null,$store_id=null,$sale_id=null,$delivery_id=null,$status=null,$types=null,$from=null,$to=null,$max=null,$order_by=array()){
		$orders = null;
		
		$orders = SalesModel::with(['sales_delivery','sales_charges','sales_details','sales_items.item_details'])
					  // ->whereHas('sales_delivery',function($query) use ($status){
					  // 	if($status != null){
					  // 		if(!is_array($status)) $query->where('status',$status);
					  // 		else $query->whereIn('status',$status);
					  // 	}
					  // })
					  ->where(function($query) use ($customer_id){
					  	if($customer_id != null) $query->where('customer_id',$customer_id);
					  })
					  ->where(function($query) use ($sale_id,$delivery_id,$from,$to,$status,$store_id){
					  	if($sale_id != null){
					  		if(!is_array($sale_id)) $query->where('sale_id',$sale_id);
					  		else $query->whereIn('sale_id',$sale_id);
					  	}					  	
					  	
					  	if($from != null){
					  		if(is_array($from)){
					  			if(isset($from['date']) && $from['date']){
					  				$query->where('order_date','>=',$from['date']);
					  			}
					  			// if(isset($from['time']) && $from['time'])
					  				// $query->where('deliver_time','>=',$from['time']);
					  		}
					  		else
			  					$query->where('order_date','>=',$from);
					  	} 
					  	if($to != null){
					  		if(is_array($to)){
					  			if(isset($to['date']) && $to['date'])
					  				$query->where('order_date','<=',$to['date']);
					  			// if(isset($to['time']) && $to['time'])
					  				// $query->where('deliver_time','<=',$to['time']);
					  		}
					  		else
			  					$query->where('order_date','<=',$to);
					  	} 

					  	// if($status != null){
					  	// 	if(!is_array($status)) $query->where('status',$status);
					  	// 	else $query->whereIn('status',$status);
					  	// }
					  	if($delivery_id != null){
					  		if(!is_array($delivery_id)) $query->where('id',$delivery_id);
					  		else $query->whereIn('id',$delivery_id);
					  	}
					  	if($store_id != null){
					  		if(!is_array($store_id)) $query->where('store_id',$store_id);
					  		else $query->whereIn('store_id',$store_id);
					  	}
					  });
		if(!empty($order_by)){			
			foreach ($order_by as $ob) {
				$orders->orderBy($ob['col'],$ob['sort']);
			}
		}
		else{
		  $orders->orderBy('deliver_date','DESC')->orderBy('deliver_time','ASC');			
		}
		// echo (str_replace_array('?',$deliveries->getBindings(),$deliveries->toSql()));
		if($sale_id != null && !is_array($sale_id)) return $deliveries->first();
		else {
			if($max != null)
				return $orders->get()->take($max);
			else
				return $orders->get();
		}
	}
	/*
	 *  
	 * returns list of menu image
	 */
	public function getStoreImage($id){
		$blob = null;
		$result = StoresModel::select('image_id')->where('location_id',$id)->first();
		if(isset($result->image_id)){
			$blob_res = FilesModel::find($result->image_id);
			if(isset($blob_res->file_data)){
				$blob = $blob_res->file_data;
			}
		}
		return $blob;
	}
	/*
	 *  
	 * returns list of menu image
	 */
	public function getBrandImage($id){
		$blob = null;
		$result = BrandsModel::select('image_id')->where('brand_id',$id)->first();
		if(isset($result->image_id)){
			$blob_res = FilesModel::find($result->image_id);
			if(isset($blob_res->file_data)){
				$blob = $blob_res->file_data;
			}
		}
		return $blob;
	}
	public function getPromoImage($id){
		$blob = null;
		$result = PromosModel::select('image_id')->where('image_id',$id)->first();
		// echo var_dump($result->image_id);
		if(isset($result->image_id)){
			$blob_res = FilesModel::find($result->image_id);
			if(isset($blob_res->file_data)){
				$blob = $blob_res->file_data;
			}
		}
		return $blob;
	}
	public function getSchedule(){
		return $schedule = OrderTypeModel::with(['orderSchedule'])->get();
		
	}
	public function getLocationCharge($request){
		return $schedule = LocationDeliveryChargeModel::where('location_id',$request->location_id)->get();
		
	}
	public function getPromos(){
		return $promos = PromosModel::get();
		
	}
	public function getAppConfig(){
		return $promos = AppConfigModel::get();
		
	}

	public function getPromoCode($code, $promo_id){
		if($code){
			return PromoCodesModel::where("code", $code)->where('inactive', '!=', 1)->orWhere('promo_id', $promo_id )->first();
		}else{
			return PromoCodesModel::where('inactive', '!=', 1)->get();
		}
	}
}
