<?php
namespace App\Services;
use Carbon\Carbon;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;

use App\Models\Menus\MenusModel;
use App\Models\Menus\MenuCategoriesModel;
use App\Models\Files\FilesModel;

class MenusService {
	/*
	 *  
	 * returns list of menus
	 */
	public function getList($categories=null,$active_only=true){
		$menus = MenusModel::with([
			'category_details:id,category_name,url',
			'menu_modifiers.modifier_group.modifier_details.modifier'
		])->where(function($query) use ($categories,$active_only){
			if($categories != null){
				if(is_array($categories)){
					$query->whereIn('category',$categories);
				}
				else{
					$query->where('category',$categories);
				}
			}
			if($active_only){
				$query->where('deleted',0);
			}
		});
		return $menus->get();
	}
	/*
	 *  
	 * returns list of menu categories
	 */
	public function getCategoryList($active_only=true){
		$result = MenuCategoriesModel::where(function($query) use ($active_only){
			if($active_only){
				$query->where('inactive',0);
				$query->where('deleted',0);
			}
		});
		return $result->get();
	}
	/*
	 *  
	 * returns list of menu categories
	 */
	public function getMenuImage($id){
		$blob = null;
		$result = MenusModel::select('image_id')->where('item_id',$id)->first();
		if(isset($result->image_id)){
			$blob_res = FilesModel::find($result->image_id);
			if(isset($blob_res->file_data)){
				$blob = $blob_res->file_data;
			}
		}
		return $blob;
	}
}
