<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\MenusService;
use App\Services\SalesService;
use App\Services\CustomersService;
use App\Services\DeliveriesService;
use App\Services\StoresService;

class MainServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(){
    	$this->app->bind('App\Services\MenusService', function ($app) {
    	  return new MenusService();
    	});
        $this->app->bind('App\Services\SalesService', function ($app) {
          return new SalesService();
        });
        $this->app->bind('App\Services\CustomersService', function ($app) {
          return new CustomersService();
        });
        $this->app->bind('App\Services\DeliveriesService', function ($app) {
          return new DeliveriesService();
        });
        $this->app->bind('App\Services\StoresService', function ($app) {
          return new StoresService();
        });
    }
}
