<?php
namespace App\Models\Users;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

use Illuminate\Auth\Authenticatable;
use Laravel\Lumen\Auth\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;

class UsersModel extends Model
{
	  use Authenticatable;

    protected $table = 'phppos_employees';
    protected $primaryKey = 'id';
    protected $hidden = [
   		'password'
   	];
    public $timestamps = false;

    protected $casts = [
        'delete' => 'int',
        'is_online' => 'int',
        'is_cashier' => 'int',
        'blacklist' => 'int',
        'is_rider' => 'int',
        'is_shopper' => 'int',
    ];
    
    public function customer_details(){
        return $this->belongsTo(CustomersModel::class,'person_id','person_id');
    }
    public function person_details(){
        return $this->belongsTo(PeoplesModel::class,'person_id','person_id');
    }
}
