<?php
namespace App\Models\Stores;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class StoresModel extends Model
{
    protected $table = 'phppos_locations';
    protected $primaryKey = 'location_id';
    public $timestamps = false;

    protected $casts = [
        'delivery_amount' => 'float',
    ];

    public function brand_details(){
        return $this->belongsTo(BrandsModel::class,'brand_id','brand_id');
    }

    public function store_menus(){
        return $this->hasMany(StoreMenusModel::class,'location_id','location_id');
    }

    public function hub_details(){
        return $this->belongsTo(StoreHubsModel::class,'location_hub_id','id');
    }
}
