<?php
namespace App\Models\Stores;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Models\Sales\SalesModel;
use App\Models\Stores\StoresModel;

class ReservationsModel extends Model
{
    protected $table = 'phppos_reservations';
    public $timestamps = false;

    public function order_details(){
        return $this->hasOne(SalesModel::class,'sale_id','sale_id');
    }
    public function store_details(){
        return $this->belongsTo(StoresModel::class,'location_id','location_id');
    }
}