<?php
namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Models\Stores\StoresModel;

class SalesModel extends Model
{
    protected $table = 'phppos_sales';
    protected $primaryKey = 'sale_id';
    public $timestamps = false;

    public function sales_details(){
        return $this->hasOne(SalesDetailsModel::class,'sale_id','sale_id');
    }

    public function sales_items(){
        return $this->hasMany(SalesItemsModel::class,'sale_id','sale_id');
    }

    public function sales_item_modifiers_list(){
        return $this->hasMany(SalesItemsModifiersModel::class,'sale_id','sale_id');
    }

    public function sales_charges(){
        return $this->hasMany(SalesChargesModel::class,'sale_id','sale_id');
    }

    public function sales_payments(){
        return $this->hasMany(SalesPaymentsModel::class,'sale_id','sale_id');
    }

    public function sales_delivery(){
        return $this->hasOne(SalesDeliveriesModel::class,'sale_id','sale_id');
    }

    public function sales_store(){
        return $this->belongsTo(StoresModel::class,'location_id','location_id');
    }
}
