<?php
namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Models\Stores\StoresModel;
use App\Models\Users\CustomersModel;

class SalesLogsModel extends Model
{
    protected $table = 'phppos_sales_logs';
    protected $primaryKey = 'id';
    public $timestamps = true;

    public function sales_details(){
        return $this->belongsTo(SalesModel::class,'sale_id','sale_id');
    }

    public function customer_details(){
        return $this->belongsTo(CustomersModel::class,'customer_id','id');
    }

    public function store_details(){
        return $this->belongsTo(StoresModel::class,'store_id','location_id');
    }
}
