<?php
namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

use App\Models\Menus\MenusModel;
use App\Models\Menus\ModifiersModel;


class SalesItemsModifiersModel extends Model
{
    protected $table = 'phppos_sales_item_modifiers';
    protected $primaryKey = 'sale_mod_id';
    public $incrementing = false;
    public $timestamps = false;

    protected $casts = [
        'mod_price' => 'float',
        'mod_unit_price' => 'float',
    ];

    public function modifier_details(){
        return $this->belongsTo(ModifiersModel::class,'mod_id','mod_id');
    }
}
