<?php
namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

use App\Models\Menus\MenusModel;


class SalesItemsModel extends Model
{
    protected $table = 'phppos_sales_items';
    protected $primaryKey = null;
    public $incrementing = false;
    public $timestamps = false;

    protected $casts = [
        'commission' => 'float',
        'item_unit_price' => 'float',
        'item_cost_price' => 'float',
        'quantity_purchased' => 'float',
    ];

    public function header_details(){
        return $this->belongsTo(SalesModel::class,'sale_id','sale_id');
    }

    public function item_details(){
        return $this->hasOne(MenusModel::class,'item_id','item_id');
    }

    public function sales_item_modifiers_list(){
        return $this->hasMany(SalesItemsModifiersModel::class,'item_id','item_id');
    }
}
