<?php
namespace App\Models\Menus;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class MenusModel extends Model
{
    protected $table = 'phppos_items';
    protected $primaryKey = 'item_id';
    public $timestamps = false;
    
    protected $casts = [
        'cost_price' => 'float',
        'unit_price' => 'float',
    ];

    public function category_details(){
        return $this->belongsTo(MenuCategoriesModel::class,'category','url');
    }

    public function menu_modifiers(){
        return $this->hasMany(MenuModifiersModel::class,'item_id','item_id');
    }
}
