<?php
namespace App\Http\Controllers;

use App\Http\Controllers\MainController;
use Illuminate\Http\Request;
use App\Services\MenusService;

use finfo;

class MenusController extends MainController{

	public $menusSrv;

	public function __construct(
	  MenusService $menusSrv
	){
	  $this->menusSrv = $menusSrv;
	}

	public function index(Request $request){
		$json = []; $status = 200; $error = "";

		$category = ($request->category ? $request->category : null );
		# GET MENUS LIST
		$json['list'] = $this->menusSrv->getList($category,true);

		return $this->apiResponse($json,$status,$error);
	}

	public function getImage(Request $request){
		$image_file = $this->menusSrv->getMenuImage($request->id);

		return response()->make($image_file, 200, array(
	        'Content-Type' => (new finfo(FILEINFO_MIME))->buffer($image_file)
	    ));
	}

}
