<?php
namespace App\Http\Controllers;

use App\Http\Controllers\MainController;
use Illuminate\Http\Request;
use App\Services\MenusService;
use App\Services\DeliveriesService;
use App\Services\StoresService;

class LoaderController extends MainController{

	public $menusSrv;
	public $deliversSrv;
	public $storesSrv;

	public function __construct(
	  MenusService $menusSrv,
	  StoresService $storesSrv,
	  DeliveriesService $deliversSrv
	){
	  $this->menusSrv = $menusSrv;
	  $this->deliversSrv = $deliversSrv;
	  $this->storesSrv = $storesSrv;
	}

	public function index(Request $request){
		$json = []; $status = 200; $error = "";

		$menu_store_based = false;
		if($request->has('menu_store_based')){
			$menu_store_based = (bool)$request->menu_store_based;
		}

		if($menu_store_based){
			$stores = $this->storesSrv->getAll();

			$menus = [];
			$brands = [];
			$brands_ = [];
			$hubs = [];
			$hubs_ = [];
			foreach ($stores as $store) {
				# SET MENU LIST
				// $location_id = $store->location_id;
				// $brand_id = $store->brand_id;
				// if(count($store->store_menus) > 0){
				// 	foreach ($store->store_menus as $menu) {
				// 		$store_unit_price = $menu->unit_price;
				// 		if($menu->menu_details){
				// 			$menu_det = $menu->getRelation('menu_details')->toArray();
				// 			$menu_det['location_id'] = $location_id;
				// 			$menu_det['brand_id'] = $brand_id;

				// 			if($store_unit_price != "")
				// 				$menu_det['unit_price'] = $store_unit_price;

				// 			$menus[] = $menu_det;
				// 		}
				// 	}
				// }
				unset($store->store_menus);
				# SET BRANDS
				if($store->brand_id != null){
					if(!in_array($store->brand_id,$brands_)){
						$brands[] = $store->brand_details;
						$brands_[] = $store->brand_id;
					}
				}
				# SET HUBS
				if($store->location_hub_id != null){
					if(!in_array($store->location_hub_id,$hubs_)){
						$hubs[] = $store->hub_details;
						$hubs_[] = $store->location_hub_id;
					}
				}
			}

			$json['brands'] = $brands;
			$json['hubs'] = $hubs;
			$json['stores'] = $stores;

			# GET CATEGORIES
			$json['categories'] = $this->menusSrv->getCategoryList();

			# GET MENUS LIST
			$menus = $this->menusSrv->getList();
			$json['list'] = $menus;
		}
		else{
			# GET STORES LIST
			$json['stores'] = $this->storesSrv->get();
			# GET CATEGORIES
			$json['categories'] = $this->menusSrv->getCategoryList();
			# GET MENUS LIST
			$menus = $this->menusSrv->getList();
			$json['list'] = $menus;
		}



		# FOR RIDERS
		if($request->load_as){
			switch ($request->load_as) {
				case 'rider':
					# GET LAST RIDERS UNDELIVERED ORDER
					$last = $this->deliversSrv->getRiderCurrent($request->user);
					if($last && $last->sale_id){
						$json['last_order'] = $this->deliversSrv->get(null,null,$last->sale_id);
					}
					break;
			}
		}
		return $this->apiResponse($json,$status,$error);
	}

	public function googleMapSearch(Request $request){
		$json = []; $status = 200; $error = "";

		$url = $request->url;

		$curl = curl_init();

		curl_setopt_array($curl, array(
		    CURLOPT_URL => $url,
		    CURLOPT_RETURNTRANSFER => true,
		    CURLOPT_ENCODING => "",
		    CURLOPT_TIMEOUT => 30000,
		    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		    CURLOPT_CUSTOMREQUEST => "GET",
		    CURLOPT_HTTPHEADER => array(
		    	// Set Here Your Requesred Headers
		        'Content-Type: application/json',
		    ),
		));


		$response = curl_exec($curl);
		$err = curl_error($curl);
		curl_close($curl);

		if ($err) {
		    echo "cURL Error #:" . $err;
		} else {
			$json = json_decode($response);
		    // print_r(json_decode($response));
		}


		return $this->apiResponse($json,$status,$error);
	}
}
